<?php

use Illuminate\Support\Facades\Route;
use App\Http\Controllers\Auth\AuthController;
use App\Http\Controllers\DashboardController;
use App\Http\Controllers\ServiceController;
use App\Http\Controllers\UserController;
use App\Http\Controllers\ServicePermissionController;
use App\Http\Controllers\ServiceRoleController;
use App\Http\Controllers\UserServicePermissionController;



// Public routes (no auth required)
Route::post('register', [AuthController::class, 'register']);
Route::post('login', [AuthController::class, 'login']);
Route::get('validate-session', [AuthController::class, 'validateSession']);
Route::post('user-map', [UserController::class, 'userMapping']);
Route::apiResource('user', UserController::class,);
// Protected routes (require authentication and session tracking)
Route::middleware(['jwt.auth', 'session.limit', 'track.activity', 'update.session'])->group(function () {
    // Auth-related routes
    // Route::post('logout', [AuthController::class, 'logout']);
    // Route::post('refresh-token', [AuthController::class, 'refreshToken']);    
    // // Service management routes
    //  Route::apiResource('services', ServiceController::class);
    //  Route::apiResource('service-permissions', ServicePermissionController::class);
    //  Route::apiResource('service-roles', ServiceRoleController::class);
    //  Route::post('user-permission', [AuthController::class, 'getUserServicePermissions']);

    // // User permission routes
    // Route::apiResource('user-service-permissions', UserServicePermissionController::class);

    // Route::post('user-service-permission', [AuthController::class, 'getUserServicePermissions']);

    // Route::delete('service-user-permission', [UserServicePermissionController::class, 'destroy']);
    // // User info route
    //  Route::post('user-map', [UserController::class,'userMapping'] );   
});

// routes/api.php
Route::get('/users/{user}/permissions', [UserServicePermissionController::class, 'getAllByService']);
Route::post('/users/{user}/permissions/toggle', [UserServicePermissionController::class, 'toggle']);
Route::post('logout', [AuthController::class, 'logout']);
Route::post('refresh-token', [AuthController::class, 'refreshToken']);
// Service management routes
Route::apiResource('services', ServiceController::class);
Route::apiResource('service-permissions', ServicePermissionController::class);
Route::apiResource('service-roles', ServiceRoleController::class);
Route::post('user-permission', [AuthController::class, 'getUserServicePermissions']);

// User permission routes
Route::apiResource('user-service-permissions', UserServicePermissionController::class);
Route::post('user-service-permission', [AuthController::class, 'getUserServicePermissions']);
Route::delete('service-user-permission', [UserServicePermissionController::class, 'destroy']);

// User info route
Route::post('user-map', [UserController::class, 'userMapping']);
Route::post('update-password', [AuthController::class, 'updatePassword']);
Route::get('users-sessions', [AuthController::class, 'allSessionStatuses']);
Route::get('user-dashboard', [DashboardController::class, 'index']);


