<?php
namespace App\Http\Middleware;

use Closure;
use Firebase\JWT\JWT;
use Firebase\JWT\Key;
use App\Models\UserSession;

class UpdateSessionActivity
{
    public function handle($request, Closure $next)
    {
        try {
            $token = $request->bearerToken();
            $secret = (string) env('JWT_SECRET');
            $payload = JWT::decode($token, new Key($secret, 'HS256'));

            UserSession::where('token_id', $payload->session_id)
                ->update(['last_activity' => now()]);

        } catch (\Exception $e) {
            // ignore
        }

        return $next($request);
    }
}
