<?php

namespace App\Http\Middleware;

use Closure;
use Illuminate\Http\Request;
use App\Models\UserSession;
use Jenssegers\Agent\Agent;

class TrackUserActivity
{
    public function handle(Request $request, Closure $next)
    {
        $response = $next($request);

        // Check if user is authenticated
        if ($request->user()) {
            $user = $request->user();
            $agent = new Agent();
            
            // Get device ID from header or token
            $deviceId = $request->header('X-Device-ID') ?? md5($request->userAgent());
            
            UserSession::updateOrCreate(
                ['user_id' => $user->id, 'device_id' => $deviceId],
                [
                    'device_type' => $this->getDeviceType($agent, $request),
                    'ip_address' => $request->ip(),
                    'user_agent' => $request->userAgent(),
                    'last_activity' => now(),
                    'is_active' => 1
                ]
            );
        }

        return $response;
    }

    protected function getDeviceType(Agent $agent, Request $request): string
    {
        $agent->setUserAgent($request->userAgent());
        return ($agent->isMobile() || $agent->isTablet()) ? 'mobile' : 'web';
    }
}