<?php
namespace App\Http\Controllers;

use App\Models\ServiceRole;
use App\Http\Controllers\Controller;
use Illuminate\Http\Request;
use App\Models\Service;

class ServiceRoleController extends Controller
{
    public function index()
    {
        // $service= ServiceRole::with('service')->get();
    $service= Service::with('serviceRoles')->get();  
        return response()->json([
                'success' => true,
                'data' => $service              
            ],200);
        }

    public function store(Request $request)
    {

        $validated = $request->validate([
             'role'=> 'required|string|max:255',
             'service_id'=> 'required|integer',                     

         ] , [
             'role.required'=> 'Name is requied',             
             'service_id.required' => 'service_ id is required',
        ]);
        $data =  ServiceRole::create($request->all());
        return response()->json([
                'success' => true,
                'message'=> "Service Role Register Succesfully",
                'data' => $data             
            ],200);
       
    }

    public function show($id)
    {
        return ServiceRole::with('service')->findOrFail($id);
    }

    public function update(Request $request, $id)
    {
        $role = ServiceRole::findOrFail($id);
        $role->update($request->all());
        return response()->json($role);
    }

    public function destroy($id)
    {
        ServiceRole::destroy($id);
        return response()->json(['message' => 'Deleted']);
    }
}
