<?php
namespace App\Http\Controllers;

use App\Models\ServicePermission;
use Illuminate\Http\Request;
use App\Http\Controllers\Controller;

class ServicePermissionController extends Controller
{
    public function index()
    {
        return ServicePermission::with(['service', 'users'])->get();
    }

    public function store(Request $request)
    {
        $request->validate([
            'service_id' => 'required|integer|exists:services,id',
            'permission' => 'required|string',
                    ]);
        $perm = ServicePermission::create($request->all());
        
        return response()->json($perm, 201);
    }

    public function show($id)
    {
        return ServicePermission::with(['service', 'users'])->findOrFail($id);
    }

    public function update(Request $request, $id)
    {
        $perm = ServicePermission::findOrFail($id);
        $perm->update($request->all());
        return response()->json($perm);
    }

    public function destroy($id)
    {
        ServicePermission::destroy($id);
        return response()->json(['message' => ' Service Permission Deleted successfully']);
    }
}
