<?php

namespace App\Http\Controllers;

use App\Models\Service;
use App\Models\ServiceRole;
use App\Models\User;
use App\Models\UserServicePermission;
use App\Models\UserSession;
use Illuminate\Database\Eloquent\Casts\Json;
use Illuminate\Http\Request;

class DashboardController extends Controller
{
   

public function index() {

    $user = User::all()->count();
    $service = Service::all()->count();
    $serviceRole = ServiceRole::all()->count();
    $userServicePermission = UserServicePermission::all()->count();
    $currentActiveUser = UserSession::with('user');

    $formatedData = [
        'user' => $user,
        'service' => $service,
        'serviceRole' => $serviceRole,
        'servicePermission' => $userServicePermission,
    ];

    return response()->json ([
        'status' => 'success',
        'data'=> $formatedData, 
    ]);
    
}

}
