<?php

namespace App\Console\Commands;
use App\Models\UserSession;
use Illuminate\Console\Command;

class CleanupSessions extends Command
{
    /**
     * The name and signature of the console command.
     *
     * @var string
  
 
     * Execute the console command.
     */
   protected $signature = 'cleanup:sessions {--days=30 : Delete records older than X days}';
    protected $description = 'Remove expired user sessions';

    public function handle()
    {
        $cutoff = now()->subDays((int) $this->option('days'));

        $deleted = UserSession::query()
            ->where('last_activity', '<', $cutoff)
            ->orWhere('is_active', 0)
            ->delete();

        $this->info("Deleted {$deleted} stale sessions");
        
        return Command::SUCCESS;
    }
}
